/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.addon.vanilla;

import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HopperBlock;
import net.minecraft.world.level.block.LeverBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.ComparatorBlockEntity;
import net.minecraft.world.level.block.entity.HopperBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.ComparatorMode;
import net.minecraft.world.level.block.state.properties.Property;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.IBlockComponentProvider;
import snownee.jade.api.IServerDataProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.Identifiers;
import snownee.jade.api.config.IPluginConfig;

public enum RedstoneProvider implements IBlockComponentProvider,
IServerDataProvider<BlockEntity>
{
    INSTANCE;


    @Override
    public void appendTooltip(ITooltip tooltip, BlockAccessor accessor, IPluginConfig config) {
        BlockState state = accessor.getBlockState();
        Block block = state.m_60734_();
        if (block instanceof LeverBlock) {
            boolean active = (Boolean)state.m_61143_((Property)BlockStateProperties.f_61448_);
            tooltip.add((Component)Component.m_237110_((String)"tooltip.jade.state", (Object[])new Object[]{Component.m_237115_((String)("tooltip.jade.state_" + (active ? "on" : "off")))}));
            return;
        }
        if (block == Blocks.f_50146_) {
            int delay = (Integer)state.m_61143_((Property)BlockStateProperties.f_61413_);
            tooltip.add((Component)Component.m_237110_((String)"tooltip.jade.delay", (Object[])new Object[]{ChatFormatting.WHITE.toString() + delay}));
            return;
        }
        if (block == Blocks.f_50328_) {
            ComparatorMode mode = (ComparatorMode)state.m_61143_((Property)BlockStateProperties.f_61393_);
            tooltip.add((Component)Component.m_237110_((String)"tooltip.jade.mode", (Object[])new Object[]{Component.m_237115_((String)("tooltip.jade.mode_" + (mode == ComparatorMode.COMPARE ? "comparator" : "subtractor"))).m_130940_(ChatFormatting.WHITE)}));
            if (accessor.getServerData().m_128441_("Signal")) {
                tooltip.add((Component)Component.m_237110_((String)"tooltip.jade.power", (Object[])new Object[]{ChatFormatting.WHITE.toString() + accessor.getServerData().m_128451_("Signal")}));
            }
            return;
        }
        if (state.m_61138_((Property)BlockStateProperties.f_61426_)) {
            tooltip.add((Component)Component.m_237110_((String)"tooltip.jade.power", (Object[])new Object[]{ChatFormatting.WHITE.toString() + state.m_61143_((Property)BlockStateProperties.f_61426_)}));
        }
        if (state.m_60734_() instanceof HopperBlock && accessor.getServerData().m_128441_("HopperLocked")) {
            tooltip.add((Component)Component.m_237115_((String)"jade.hopper.locked").m_130940_(ChatFormatting.RED));
        }
    }

    @Override
    public void appendServerData(CompoundTag data, ServerPlayer player, Level world, BlockEntity blockEntity, boolean showDetails) {
        if (blockEntity instanceof ComparatorBlockEntity) {
            ComparatorBlockEntity comparator = (ComparatorBlockEntity)blockEntity;
            data.m_128405_("Signal", comparator.m_59182_());
        } else if (blockEntity instanceof HopperBlockEntity) {
            HopperBlockEntity hopper = (HopperBlockEntity)blockEntity;
            BlockState state = blockEntity.m_58900_();
            if (state.m_61138_((Property)BlockStateProperties.f_61431_) && !((Boolean)state.m_61143_((Property)BlockStateProperties.f_61431_)).booleanValue()) {
                data.m_128379_("HopperLocked", true);
            }
        }
    }

    @Override
    public ResourceLocation getUid() {
        return Identifiers.MC_REDSTONE;
    }
}

